/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBHeaderMegaMenu = Object.create(STBModule.prototype);

STBHeaderMegaMenu.name = "HeaderMegaMenu";
STBHeaderMegaMenu.updateStyle = function () {

	var $megaDropdown = jQuery('.mega-dropdown');

	var dropDownClassAdd = function() {
		jQuery("body").addClass(jQuery(this).attr("data-style"));
		//carousels will have 0px height without refresh.
		jQuery(this).find(".owl-carousel").trigger("refresh");


		if (!jQuery("body").hasClass("moveMainNav") && !jQuery("body").hasClass("moveSecNav")) {
			var elements = jQuery(this).find(".widget-head");
			elements.removeClass("animated-title").addClass("clear-animation");

			setTimeout(function(){			
				elements.removeClass("clear-animation").addClass("animated-title");
			}, 1);
		}
	}

	var dropDownClassRemove = function() {
		jQuery("body").removeClass(jQuery(this).attr("data-style"));
	}

	$megaDropdown.hover(dropDownClassAdd , dropDownClassRemove);


	//add control classes to identify the menu holder. z-index & pos relative issue
	
	if ($megaDropdown.length){
		$megaDropdown.each(function() {
			var holder = jQuery(this).closest(".navbar");

			if (holder.hasClass("sec-nav")) {
				jQuery(this).attr("data-style" , jQuery(this).attr("data-style") + " with-sec-nav");
			}

			if (holder.hasClass("main-nav")) {
				jQuery(this).attr("data-style" , jQuery(this).attr("data-style") + " with-main-nav");
			}

		});
	}

}


STBHeaderMegaMenu.updateActive = function() {
	if (jQuery("header .active").length){
	} else {
		//detect a link ( it might be in mega menu )

		var url = window.location.href,
			base = jQuery("base").attr("href"),
			left = url.replace(base , "/"),
			link = jQuery("header a[href='" + left +"']");

		if (!link.length){
			link = jQuery("header a[href='" + url +"']");
		}

		if (link.length > 0) {

			var parent = link.closest("li"),
				holder = link.closest(".dropdown");

			if (parent.length > 0) {
				parent.addClass("active");
			}

			if (holder.length > 0) {
				holder.addClass("active");
			}
		}
	}

}


STBHeaderMegaMenu.runOnReady = function() {
	STBHeaderMegaMenu.updateStyle();
	STBHeaderMegaMenu.updateActive();
}


site.registerModule(STBHeaderMegaMenu);